#include <bits/stdc++.h>
using namespace std;

const int MAXN = 300005;

struct segment{
    int val;
    int lazy;
} seg[4*MAXN+5];

void init(int node, int l, int r){
    seg[node].val = -MAXN;
    seg[node].lazy = -MAXN;
    if(l == r) return;
    int mid = (l+r)/2;
    init(node*2, l, mid);
    init(node*2+1, mid+1, r);
}

void propagate(int node, int l, int r){
    seg[node].val = max(seg[node].val, seg[node].lazy);
    if(l == r){
        seg[node].lazy = -MAXN;
        return;
    }
    seg[node*2].lazy = max(seg[node*2].lazy, seg[node].lazy);
    seg[node*2+1].lazy = max(seg[node*2+1].lazy, seg[node].lazy);
    seg[node].lazy = -MAXN;
}

int query(int node, int l, int r, int tl, int tr){
    propagate(node, l, r);
    if(l > tr || tl > r) return -MAXN;
    if(tl <= l && r <= tr) return seg[node].val;
    int mid = (l+r)/2;
    return max(query(node*2, l, mid, tl, tr), query(node*2+1, mid+1, r, tl, tr));
}

void upd(int node, int l, int r, int tl, int tr, int val){
    propagate(node, l, r);
    if(l > tr || tl > r) return;
    if(tl <= l && r <= tr){
        seg[node].lazy = max(seg[node].lazy, val);
        propagate(node, l, r);
        return;
    }
    int mid = (l+r)/2;
    upd(node*2, l, mid, tl, tr, val);
    upd(node*2+1, mid+1, r, tl, tr, val);
    seg[node].val = max(seg[node*2].val, seg[node*2+1].val);
}

int Slamke(int N, int* A, int M, int* T, int* X, int* Y) {
    init(1, 1, N);
    for(int i=1; i<=N; i++){
        if(A[i] == 1) upd(1, 1, N, i, i, 0);
    }
    for(int i=1; i<=M; i++){
        if(T[i] == 1){
            int mx = query(1, 1, N, X[i], Y[i]);
            upd(1, 1, N, X[i], Y[i], mx);
        }
        else{
            int mx = query(1, 1, N, X[i], X[i]);
            upd(1, 1, N, X[i], X[i], mx+1);
        }
    }
    return query(1, 1, N, 1, N);
}

/*
6
3 1 4 6 5 2
 4
1 2 4
2 5 0
1 4 6
2 5 0
1
*/